/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.json;

import com.aptana.json.IContextHandler;
import com.aptana.json.ISchemaContext;
import com.aptana.json.IState;
import com.aptana.json.Messages;
import java.util.Stack;

public class SchemaContext
implements ISchemaContext {
    private Stack<IState> _typeStack;
    private IContextHandler _handler;

    public void addElement(String elementTypeName, IState elementType) {
        if (this._handler != null) {
            this._handler.addElement(elementTypeName, elementType);
        }
    }

    public void createType(String typeName, IState type, Object value) {
        if (this._handler != null) {
            this._handler.createType(typeName, type, value);
        }
    }

    public IState getCurrentType() {
        IState result = null;
        if (this.hasTypes()) {
            result = this._typeStack.peek();
        }
        return result;
    }

    public IContextHandler getHandler() {
        return this._handler;
    }

    public boolean hasTypes() {
        return this._typeStack != null && !this._typeStack.isEmpty();
    }

    public void popType() {
        if (this._typeStack != null) {
            if (!this._typeStack.isEmpty()) {
                this._typeStack.pop();
            } else {
                throw new IllegalArgumentException(Messages.SchemaContext_Popped_Empty_Stack);
            }
        }
    }

    public void pushType(String typeName, IState type) {
        if (this._typeStack == null) {
            this._typeStack = new Stack();
        }
        this._typeStack.push(type);
    }

    public void reset() {
        this._typeStack = null;
    }

    public void setHandler(IContextHandler handler) {
        this._handler = handler;
    }

    public void setProperty(String propertyName, String propertyTypeName, IState propertyType) {
        if (this._handler != null) {
            this._handler.setProperty(propertyName, propertyTypeName, propertyType);
        }
    }
}

